<?php
// File: api/application/models/Splash_model.php
// Model untuk akses data tbl_mst_splash dengan logging detail

defined('BASEPATH') OR exit('No direct script access allowed');

class Splash_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        log_message('debug', '[SplashModel] __construct loaded');
    }

    /**
     * get_latest
     *
     * Mengambil baris dengan splash_version tertinggi
     *
     * @return object|null
     */
    public function get_latest() {
        log_message('debug', '[SplashModel] get_latest() called');
        $query = $this->db
            ->select('splash_version, splash_url, splash_time')
            ->order_by('splash_version', 'DESC')
            ->limit(1)
            ->get('tbl_mst_splash');
        log_message('debug', '[SplashModel] Executed query: ' . $this->db->last_query());
        $row = $query->row();
        log_message('debug', '[SplashModel] Query result: ' . json_encode($row));
        return $row;
    }
}
