<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Otp_model extends CI_Model
{
    protected $table = 'tbl_otp';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Simpan OTP baru
     */
    public function insert_otp($nomor_hp, $otp_code)
    {
        $data = [
            'nomor_hp'        => $nomor_hp,
            'otp_kode'        => $otp_code,
            'otp_created_at'  => date('Y-m-d H:i:s'),
        ];
        return $this->db->insert($this->table, $data);
    }

    /**
     * Ambil OTP valid (belum kadaluarsa 5 menit)
     */
    public function get_valid_otp($nomor_hp, $otp_code)
    {
        $time_limit = date('Y-m-d H:i:s', strtotime('-5 minutes'));
        $q = $this->db
                  ->where('nomor_hp', $nomor_hp)
                  ->where('otp_kode', $otp_code)
                  ->where('otp_created_at >=', $time_limit)
                  ->get($this->table);
        return $q->row_array();
    }

    /**
     * Hapus semua OTP yang terkait nomor HP ini
     */
    public function delete_all_otp($nomor_hp)
    {
        return $this->db
                    ->where('nomor_hp', $nomor_hp)
                    ->delete($this->table);
    }
}
