<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

function send_fcm_v1($title, $body, $token)
{
    $CI =& get_instance();
    $serviceAccountPath = APPPATH . 'config/firebase/service-account.json';
    $projectId = json_decode(file_get_contents($serviceAccountPath), true)['project_id'];

    // Step 1: Dapatkan access token
    $jwt = generate_jwt($serviceAccountPath);
    $accessToken = fetch_access_token($jwt);

    // Step 2: Kirim notifikasi
    $url = "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send";

    $payload = [
        "message" => [
            "token" => $token,
            "notification" => [
                "title" => $title,
                "body" => $body
            ],
            "data" => [
                "click_action" => "FLUTTER_NOTIFICATION_CLICK",
                "status" => "notif",
                "title" => $title,
                "body" => $body
            ],
            "android" => [
                "priority" => "high",
                "notification" => [
                    "sound" => "default",
                    "click_action" => "FLUTTER_NOTIFICATION_CLICK"
                ]
            ]
        ]
    ];


    $headers = [
        "Authorization: Bearer $accessToken",
        "Content-Type: application/json"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    log_message('error', "[FCM-Send] Token: $token | Response: $response");
    curl_close($ch);

    return $response;
}

function generate_jwt($serviceAccountPath)
{
    $credentials = json_decode(file_get_contents($serviceAccountPath), true);
    $now = time();
    $exp = $now + 3600;
    $jwtHeader = ['alg' => 'RS256', 'typ' => 'JWT'];
    $jwtClaim = [
        'iss' => $credentials['client_email'],
        'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
        'aud' => $credentials['token_uri'],
        'iat' => $now,
        'exp' => $exp,
    ];

    $jwtHeaderEncoded = rtrim(strtr(base64_encode(json_encode($jwtHeader)), '+/', '-_'), '=');
    $jwtClaimEncoded = rtrim(strtr(base64_encode(json_encode($jwtClaim)), '+/', '-_'), '=');
    $data = $jwtHeaderEncoded . '.' . $jwtClaimEncoded;

    // Gunakan OpenSSL untuk tanda tangan JWT
    openssl_sign($data, $signature, $credentials['private_key'], 'SHA256');
    $signatureEncoded = rtrim(strtr(base64_encode($signature), '+/', '-_'), '=');

    return $data . '.' . $signatureEncoded;
}

function fetch_access_token($jwt)
{
    $url = "https://oauth2.googleapis.com/token";
    $postFields = http_build_query([
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt,
    ]);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
    $response = curl_exec($ch);
    curl_close($ch);

    $json = json_decode($response, true);
    return $json['access_token'] ?? null;
}

function notify_user_transaction($user_kode, $title, $body) {
    $ci = &get_instance();
    $ci->load->database();
    log_message('error', "[FCM-Notify] Kirim ke user: $user_kode | Title: $title");
    $row = $ci->db->get_where('tbl_mst_user', ['mst_user_kode' => $user_kode])->row();
    if ($row && $row->mst_user_firebase) {
        return send_fcm_v1($title, $body, $row->mst_user_firebase);
    }
    return false;
}
