<?php
if (!function_exists('env')) {
    function env($key, $default = null) {
        static $env;
        if ($env === null) {
            $env = [];
            $envPath = FCPATH . '.env';
            if (file_exists($envPath)) {
                $lines = file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                foreach ($lines as $line) {
                    if (strpos(trim($line), '#') === 0 || strpos($line, '=') === false) continue;
                    list($name, $value) = explode('=', $line, 2);
                    $env[trim($name)] = trim($value);
                }
            }
        }
        return $env[$key] ?? $default;
    }
}
