<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_vidio_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$vidio = $this->db->query("SELECT * FROM tbl_mst_vidio  order by mst_vidio_urutan asc");

		if ($vidio->num_rows() > 0) {
			foreach ($vidio->result() as $row) {
				$data['vidio'][] = array(
					'mst_vidio_kode' => encrypt($row->mst_vidio_kode, $this->config->item('key')),
					'mst_vidio_nama' => encrypt($row->mst_vidio_nama, $this->config->item('key')),
					'mst_vidio_keterangan' => encrypt($row->mst_vidio_keterangan, $this->config->item('key')),
					'mst_vidio_notasi' => encrypt($row->mst_vidio_notasi, $this->config->item('key')),
					'mst_vidio_harga' => encrypt(number_format($row->mst_vidio_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_vidio_admin' => encrypt(number_format($row->mst_vidio_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_vidio_total' => encrypt(number_format($row->mst_vidio_harga + $row->mst_vidio_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_vidio_poin' => encrypt($row->mst_vidio_poin, $this->config->item('key')),
					'mst_vidio_urutan' => encrypt($row->mst_vidio_urutan, $this->config->item('key')),
					'mst_vidio_status' => encrypt($row->mst_vidio_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
