<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_vidio_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//VIDIO
		$trx_vidio_kode = $this->trx_vidio_kode();

		//PANGGIL VIDIO
		$vidio = $this->db->query("SELECT * FROM tbl_trx_vidio 
									WHERE 
									trx_vidio_kode='$trx_vidio_kode' and 
									trx_vidio_user_kode='$mst_user_kode'");
		if ($vidio->num_rows() > 0) {
			foreach ($vidio->result() as $row) {
				$data['transaksi'][] = array(
					'trx_vidio_kode' => encrypt($row->trx_vidio_kode, $this->config->item('key')),
					'trx_vidio_user_kode' => encrypt($row->trx_vidio_user_kode, $this->config->item('key')),
					'trx_vidio_nomor' => encrypt($row->trx_vidio_nomor, $this->config->item('key')),
					'trx_vidio_nama' => encrypt($row->trx_vidio_nama, $this->config->item('key')),
					'trx_vidio_admin' => encrypt(number_format($row->trx_vidio_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_vidio_harga' => encrypt(number_format($row->trx_vidio_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_vidio_total' => encrypt(number_format($row->trx_vidio_admin + $row->trx_vidio_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_vidio_poin' => encrypt($row->trx_vidio_poin, $this->config->item('key')),
					'trx_vidio_sn' => encrypt($row->trx_vidio_sn, $this->config->item('key')),
					'trx_vidio_keterangan' => encrypt($row->trx_vidio_keterangan, $this->config->item('key')),
					'trx_vidio_notasi' => encrypt($row->trx_vidio_notasi, $this->config->item('key')),
					'trx_vidio_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_vidio_tanggal)), $this->config->item('key')),
					'trx_vidio_icon' => encrypt($row->trx_vidio_icon, $this->config->item('key')),
					'trx_vidio_rc' => encrypt($row->trx_vidio_rc, $this->config->item('key')),
					'trx_vidio_status' => encrypt($row->trx_vidio_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_vidio_kode()
	{
		$input = decrypt($this->input->post("trx_vidio_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
