<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Api_xendit_callback extends CI_Controller
{
    public function index()
    {
        $reqHeaders = $this->input->request_headers();
        $xIncomingCallbackTokenHeader = $reqHeaders['X-Callback-Token'];
        $xXenditCallback = $this->config->item('xendit_callback');

        if ($xIncomingCallbackTokenHeader == $xXenditCallback) {
            $rawRequestInput = file_get_contents('php://input');
            $arrRequestInput = json_decode($rawRequestInput, true);

            $fcmUrl = 'https://fcm.googleapis.com/fcm/send';

            $notification = array(
                'type' => 1,
                'title' => 'Callback Xendit',
                'body' => $arrRequestInput,
                'click_action' => 'mainactivity',
                'sound' => 'default',
                'icon'  => 'ic_notification',
            );


            $fcmNotification = [
                //'registration_ids' => '', //multple pasca array
                'to'        => 'fqvw-fO4SgehgI9A7ooRnu:APA91bHcL5UNAPQTXW9OrZPNZUioQKc2dwUh6taNWjpx8s_4wswf89hqFnY6wE5J4HnYZW3XHY46P1YQ2Nk3x1ZyRL5rU5XVxeLxkdzg70g0gwTKJ_R2trCvoFsz_xnhkC1Fndd2_FCk',
                'data' => $notification,
                'notification' => $notification,
                'priority' => 'high',
                'apns-priority' => '5'
            ];



            $headers = [
                'Authorization: key=' . $this->config->item('firebase_key'),
                'Content-Type: application/json'
            ];


            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $fcmUrl);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmNotification));
            $result = curl_exec($ch);
            curl_close($ch);
        } else {
            $sess["status"] = "400";
            $sess["pesan"] = "Token salah";
            $keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
            $sess['data'] = array(
                'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
                'value' =>  encrypt(json_encode(array()), $keytoken)
            );
            echo json_encode($sess);
        }
    }

    public function encrypt($input, $key)
    {
        $size = mcrypt_get_block_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_ECB);
        $input = $this->pkcs5_pad($input, $size);
        $td = mcrypt_module_open(MCRYPT_RIJNDAEL_128, '', MCRYPT_MODE_ECB, '');
        $iv = mcrypt_create_iv(mcrypt_enc_get_iv_size($td), MCRYPT_RAND);
        mcrypt_generic_init($td, $key, $iv);
        $data = mcrypt_generic($td, $input);
        mcrypt_generic_deinit($td);
        mcrypt_module_close($td);
        $data = base64_encode($data);
        $data = str_replace("+", "-", $data);
        return $data;
    }

    public function decrypt($sStr, $sKey)
    {
        $sStr = str_replace("-", "+", $sStr);
        $decrypted = mcrypt_decrypt(
            MCRYPT_RIJNDAEL_128,
            $sKey,
            base64_decode($sStr),
            MCRYPT_MODE_ECB
        );
        $dec_s = strlen($decrypted);
        $padding = ord($decrypted[$dec_s - 1]);
        $decrypted = substr($decrypted, 0, -$padding);
        return $decrypted;
    }

    private static function pkcs5_pad($text, $blocksize)
    {
        $pad = $blocksize - (strlen($text) % $blocksize);
        return $text . str_repeat(chr($pad), $pad);
    }
}
