<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");

class Api_digiflazz_pascabayar extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
		$this->methods['index_post']['limit_transaksi'] = 1;
	}


	public function cek_post()
	{
		$this->input->post("mst_token_kode", true);
		date_default_timezone_set("Asia/Jakarta");
		$digiflazz_produk_kode =  $this->input->post("digiflazz_produk_kode", true);
		$digiflazz_transaksi_kode =  "TRX-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
		$digiflazz_nomor_customer = $this->input->post("digiflazz_nomor_customer", true);


		$url = $this->config->item('digiflazz_api_url');

		$header = array(
			'Content-Type: text/plain',
		);

		$data = array(
			"commands" => "inq-pasca",
			'username' => $this->config->item('digiflazz_api_username'),
			'buyer_sku_code' => $digiflazz_produk_kode,
			'customer_no' => $digiflazz_nomor_customer,
			'ref_id' => $digiflazz_transaksi_kode,
			'testing' => $this->config->item('digiflazz_api_testing'),
			'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . $digiflazz_transaksi_kode)
		);

		$json = json_encode($data);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$result = curl_exec($ch);
		curl_close($ch);
		$response = json_decode($result, true);

		$sess["status"] = "00";
		$sess["message"] = "Produk tidak ditemukan";
		$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));
		$key['keytoken'] = encrypt($keytoken, $this->config->item('keytoken'));
		$key['keyakses'] = encrypt(json_encode($sess), $keytoken);
		echo json_encode($response);
	}

	public function bayar_post()
	{
		$this->input->post("mst_token_kode", true);
		date_default_timezone_set("Asia/Jakarta");
		$digiflazz_produk_kode =  $this->input->post("digiflazz_produk_kode", true);
		$digiflazz_transaksi_kode =  $this->input->post("digiflazz_transaksi_kode", true);
		$digiflazz_nomor_customer = $this->input->post("digiflazz_nomor_customer", true);


		$url = $this->config->item('digiflazz_api_url');

		$header = array(
			'Content-Type: text/plain',
		);

		$data = array(
			"commands" => "pay-pasca",
			'username' => $this->config->item('digiflazz_api_username'),
			'buyer_sku_code' => $digiflazz_produk_kode,
			'customer_no' => $digiflazz_nomor_customer,
			'ref_id' => $digiflazz_transaksi_kode,
			'testing' => $this->config->item('digiflazz_api_testing'),
			'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . $digiflazz_transaksi_kode)
		);

		$json = json_encode($data);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$result = curl_exec($ch);
		curl_close($ch);
		$response = json_decode($result, true);

		$sess["status"] = "00";
		$sess["message"] = "Produk tidak ditemukan";
		$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));
		$key['keytoken'] = encrypt($keytoken, $this->config->item('keytoken'));
		$key['keyakses'] = encrypt(json_encode($sess), $keytoken);
		echo json_encode($response);
	}

	private function digiflazz_produk_kode()
	{
		$input = decrypt($this->input->post("digiflazz_produk_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = "Token tidak valid";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));
				$key['keytoken'] = encrypt($keytoken, $this->config->item('keytoken'));
				$key['keyakses'] = encrypt(json_encode($sess), $keytoken);
				echo json_encode($key);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = "Token tidak valid";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));
			$key['keytoken'] = encrypt($keytoken, $this->config->item('keytoken'));
			$key['keyakses'] = encrypt(json_encode($sess), $keytoken);
			echo json_encode($key);
			exit();
		}
	}

	private function digiflazz_nomor_customer()
	{
	}
}
