<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_traveloka_activity_transaksi extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
		$this->methods['index_post']['limit_transaksi'] = 1;
	}

	private $str_mst_user_zona_waktu;
	private $str_mst_user_kode;
	private $str_mst_traveloka_kode;
	private $str_trx_traveloka_nomor;
	private $str_trx_traveloka_nama;
	private $str_trx_traveloka_admin;
	private $str_trx_traveloka_harga;
	private $str_trx_traveloka_poin;
	private $str_trx_traveloka_keterangan;
	private $str_trx_traveloka_notasi;

	public function index_post()
	{
		$this->transaksi_traveloka();

		//TIME ZONE
		date_default_timezone_set($this->str_mst_user_zona_waktu);

		//USER
		$mst_user_kode = $this->str_mst_user_kode;

		//traveloka
		$mst_traveloka_kode = $this->str_mst_traveloka_kode;

		//TRANSAKSI
		$trx_traveloka_kode =  "TRAVELOKA-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
		$trx_traveloka_tanggal = date('Y-m-d H:i:s');
		$trx_traveloka_nomor = $this->str_trx_traveloka_nomor;
		$trx_traveloka_nama = $this->str_trx_traveloka_nama;
		$trx_traveloka_admin = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->str_trx_traveloka_admin);
		$trx_traveloka_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->str_trx_traveloka_harga);
		$trx_traveloka_total = $trx_traveloka_harga + $trx_traveloka_admin;
		$trx_traveloka_poin = $this->str_trx_traveloka_poin;
		$trx_traveloka_keterangan = $this->str_trx_traveloka_keterangan;
		$trx_traveloka_notasi = $this->str_trx_traveloka_notasi;
		$trx_traveloka_icon = $this->config->item('icon_traveloka');

		//KATEGORI TRANSAKSI
		$trx_transaksi_kategori =  $this->config->item('transaksi_traveloka');

		//CEK SALDO
		$saldo = $this->db->query("SELECT * FROM tbl_mst_saldo WHERE 
									mst_saldo_user_kode='$mst_user_kode' and 
									mst_saldo_jumlah >= '$trx_traveloka_total'");
		if ($saldo->num_rows() > 0) {
			//SALDO CUKUP
			//DIGIFLAZZ
			$url = $this->config->item('digiflazz_api_url');
			$header = array(
				'Content-Type: text/plain',
			);
			$params = array(
				'username' => $this->config->item('digiflazz_api_username'),
				'buyer_sku_code' => $mst_traveloka_kode,
				'customer_no' => $trx_traveloka_nomor,
				'ref_id' => $trx_traveloka_kode,
				'testing' => $this->config->item('digiflazz_api_testing'),
				'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . $trx_traveloka_kode)
			);
			$json = json_encode($params);
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
			curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$result = curl_exec($ch);
			curl_close($ch);
			$response = json_decode($result, true)['data'];

			if (!empty($response['rc'])) {
				//DIGIFLAZZ
				$rc = $response['rc'];
				$status = $response['status'];
				$sn = $response['sn'];

				//TRANSAKSI SUKSES
				if ($rc == "03") {
					//INSERT KE tbl_trx_traveloka
					$this->db->query("insert into tbl_trx_traveloka (
								trx_traveloka_kode, 
								trx_traveloka_user_kode, 
								trx_traveloka_nomor, 
								trx_traveloka_nama, 
								trx_traveloka_admin,
								trx_traveloka_harga,
								trx_traveloka_poin,
								trx_traveloka_sn, 
								trx_traveloka_keterangan, 
								trx_traveloka_notasi, 
								trx_traveloka_tanggal,
								trx_traveloka_icon, 
								trx_traveloka_rc,
								trx_traveloka_status) values (
								'$trx_traveloka_kode', 
								'$mst_user_kode', 
								'$trx_traveloka_nomor', 
								'$trx_traveloka_nama', 
								'$trx_traveloka_admin',
								'$trx_traveloka_harga', 
								'$trx_traveloka_poin', 
								'$sn', 
								'$trx_traveloka_keterangan', 
								'Transaksi masih pending, cek status transaksi secara berkala', 
								'$trx_traveloka_tanggal', 
								'$trx_traveloka_icon',
								'$rc',
								'$status')");

					//INSERT KE tbl_trx_transaksi
					$this->db->query("insert into tbl_trx_transaksi (
								trx_transaksi_kode, 
								trx_transaksi_user_kode, 
								trx_transaksi_kategori, 
								trx_transaksi_nomor, 
								trx_transaksi_nama, 
								trx_transaksi_jumlah,
								trx_transaksi_keterangan,
								trx_transaksi_notasi, 
								trx_transaksi_tanggal, 
								trx_transaksi_icon, 
								trx_transaksi_rc,
								trx_transaksi_status) values (
								'$trx_traveloka_kode', 
								'$mst_user_kode', 
								'$trx_transaksi_kategori', 
								'$trx_traveloka_nomor',
								'$trx_traveloka_nama', 
								'$trx_traveloka_total', 
								'$trx_traveloka_keterangan',
								'Transaksi masih pending, cek status transaksi secara berkala ',  
								'$trx_traveloka_tanggal', 
								'$trx_traveloka_icon', 
								'$rc', 
								'$status')");

					//UPDATE tbl_mst_saldo
					$this->db->query("UPDATE tbl_mst_saldo set 
									mst_saldo_jumlah=mst_saldo_jumlah - '$trx_traveloka_total'
									where
									mst_saldo_user_kode='$mst_user_kode'");

					//PANGGIL traveloka
					$traveloka = $this->db->query("SELECT * FROM tbl_trx_traveloka 
											WHERE 
											trx_traveloka_kode='$trx_traveloka_kode' and 
											trx_traveloka_user_kode='$mst_user_kode'");
					if ($traveloka->num_rows() > 0) {
						foreach ($traveloka->result() as $row) {
							$data['transaksi'][] = array(
								'trx_traveloka_kode' => encrypt($row->trx_traveloka_kode, $this->config->item('key')),
							);
						}

						//BERHASIL
						$sess["status"] = "11";
						$sess["pesan"] = "Transaksi berhasil dan ditemukan. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
						$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
						$sess['data'] = array(
							'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
							'value' =>  encrypt(json_encode($data), $keytoken)
						);
						echo json_encode($sess);
					} else {
						//BERHASIL TAPI GAGAL MEMANGGIL
						$sess["status"] = "22";
						$sess["pesan"] = "Transaksi berhasil dilakukan. Pergi ke riwayat transaksi untuk melihat detail transaksi kamu";
						$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
						$sess['data'] = array(
							'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
							'value' =>  encrypt(json_encode(array()), $keytoken)
						);
						echo json_encode($sess);
					}
				} else {
					//GAGAL
					$sess["status"] = "33";
					$sess["pesan"] = $rc . " Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
					$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
					$sess['data'] = array(
						'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
						'value' =>  encrypt(json_encode(array()), $keytoken)
					);
					echo json_encode($sess);
				}
			} else {
				//GAGAL
				$sess["status"] = "34";
				$sess["pesan"] = "Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}
		} else {
			//SALDO TIDAK CUKUP
			$sess["status"] = "35";
			$sess["pesan"] = "Saldo kamu tidak cukup. Pastikan saldo kamu cukup sebelum melakukan transaksi";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}

	private function transaksi_traveloka()
	{

		$input = decrypt($this->input->post("transaksi_traveloka", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				$array = explode(".....", $data);
				$mst_transaksi = "";
				foreach ($array as $item) {
					$itemArray = explode(":", $item);
					$key = decrypt(trim($itemArray[0]), $this->config->item('key'));
					$value = trim($itemArray[1]);

					//AMBIL KEY TRANSAKSI
					if ($key == 'mst_transaksi') {
						$mst_transaksi = $value;
					}

					//GENERATE POST SELAIN KEY TRANSAKSI
					if ($key != 'mst_transaksi') {
						$this->transaksi_traveloka_request($key, $mst_transaksi, $value);
					}
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function transaksi_traveloka_request($key, $mst_transaksi, $value)
	{
		$transaksi = decrypt($mst_transaksi, $this->config->item('key'));
		$input = decrypt($value, $transaksi);
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				if ($key == 'mst_user_kode') {
					return $this->str_mst_user_kode = $data;
				}

				if ($key == 'mst_user_zona_waktu') {
					return $this->str_mst_user_zona_waktu = $data;
				}

				if ($key == 'mst_traveloka_kode') {
					return $this->str_mst_traveloka_kode = $data;
				}

				if ($key == 'trx_traveloka_nomor') {
					return $this->str_trx_traveloka_nomor = $data;
				}

				if ($key == 'trx_traveloka_nama') {
					return $this->str_trx_traveloka_nama = $data;
				}

				if ($key == 'trx_traveloka_admin') {
					return $this->str_trx_traveloka_admin = $data;
				}

				if ($key == 'trx_traveloka_harga') {
					return $this->str_trx_traveloka_harga = $data;
				}

				if ($key == 'trx_traveloka_poin') {
					return $this->str_trx_traveloka_poin = $data;
				}

				if ($key == 'trx_traveloka_keterangan') {
					return $this->str_trx_traveloka_keterangan = $data;
				}

				if ($key == 'trx_traveloka_notasi') {
					return $this->str_trx_traveloka_notasi = $data;
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
