<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_traveloka_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$traveloka = $this->db->query("SELECT * FROM tbl_mst_traveloka  order by mst_traveloka_urutan asc");

		if ($traveloka->num_rows() > 0) {
			foreach ($traveloka->result() as $row) {
				$data['traveloka'][] = array(
					'mst_traveloka_kode' => encrypt($row->mst_traveloka_kode, $this->config->item('key')),
					'mst_traveloka_nama' => encrypt($row->mst_traveloka_nama, $this->config->item('key')),
					'mst_traveloka_keterangan' => encrypt($row->mst_traveloka_keterangan, $this->config->item('key')),
					'mst_traveloka_notasi' => encrypt($row->mst_traveloka_notasi, $this->config->item('key')),
					'mst_traveloka_harga' => encrypt(number_format($row->mst_traveloka_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_traveloka_admin' => encrypt(number_format($row->mst_traveloka_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_traveloka_total' => encrypt(number_format($row->mst_traveloka_harga + $row->mst_traveloka_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_traveloka_poin' => encrypt($row->mst_traveloka_poin, $this->config->item('key')),
					'mst_traveloka_urutan' => encrypt($row->mst_traveloka_urutan, $this->config->item('key')),
					'mst_traveloka_status' => encrypt($row->mst_traveloka_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
