<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_traveloka_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//TRAVELOKA
		$trx_traveloka_kode = $this->trx_traveloka_kode();

		//PANGGIL TRAVELOKA
		$traveloka = $this->db->query("SELECT * FROM tbl_trx_traveloka 
									WHERE 
									trx_traveloka_kode='$trx_traveloka_kode' and 
									trx_traveloka_user_kode='$mst_user_kode'");
		if ($traveloka->num_rows() > 0) {
			foreach ($traveloka->result() as $row) {
				$data['transaksi'][] = array(
					'trx_traveloka_kode' => encrypt($row->trx_traveloka_kode, $this->config->item('key')),
					'trx_traveloka_user_kode' => encrypt($row->trx_traveloka_user_kode, $this->config->item('key')),
					'trx_traveloka_nomor' => encrypt($row->trx_traveloka_nomor, $this->config->item('key')),
					'trx_traveloka_nama' => encrypt($row->trx_traveloka_nama, $this->config->item('key')),
					'trx_traveloka_admin' => encrypt(number_format($row->trx_traveloka_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_traveloka_harga' => encrypt(number_format($row->trx_traveloka_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_traveloka_total' => encrypt(number_format($row->trx_traveloka_admin + $row->trx_traveloka_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_traveloka_poin' => encrypt($row->trx_traveloka_poin, $this->config->item('key')),
					'trx_traveloka_sn' => encrypt($row->trx_traveloka_sn, $this->config->item('key')),
					'trx_traveloka_keterangan' => encrypt($row->trx_traveloka_keterangan, $this->config->item('key')),
					'trx_traveloka_notasi' => encrypt($row->trx_traveloka_notasi, $this->config->item('key')),
					'trx_traveloka_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_traveloka_tanggal)), $this->config->item('key')),
					'trx_traveloka_icon' => encrypt($row->trx_traveloka_icon, $this->config->item('key')),
					'trx_traveloka_rc' => encrypt($row->trx_traveloka_rc, $this->config->item('key')),
					'trx_traveloka_status' => encrypt($row->trx_traveloka_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_traveloka_kode()
	{
		$input = decrypt($this->input->post("trx_traveloka_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
