<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_token_pln_activity_pelanggan extends REST_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}

	public function index_post()
	{
		$trx_token_pln_pelanggan_nomor = $this->trx_token_pln_pelanggan_nomor();
		if ($trx_token_pln_pelanggan_nomor === false) return;

		$url = $this->config->item('digiflazz_api_url');
		$header = array('Content-Type: text/plain');

		$data = array(
			'commands' => "pln-subscribe",
			'customer_no' => $trx_token_pln_pelanggan_nomor
		);

		$json = json_encode($data);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$result = curl_exec($ch);
		curl_close($ch);
		$response = json_decode($result, true)['data'] ?? [];

		if (!empty($response['name'])) {
			$customer_no = $response['customer_no'];
			$meter_no = $response['meter_no'];
			$subscriber_id = $response['subscriber_id'];
			$name = $response['name'];
			$segment_power = str_replace(' ', '', strstr($response['segment_power'], '/', true));
			$daya = ltrim(substr(ltrim($response['segment_power'], '0'), strpos(ltrim($response['segment_power'], '0'), "/") + 1), '0');

			$data['pelanggan'][] = array(
				'trx_token_pln_pelanggan_nomor' => encrypt($customer_no, $this->config->item('key')),
				'trx_token_pln_pelanggan_id' => encrypt($subscriber_id, $this->config->item('key')),
				'trx_token_pln_pelanggan_nama' => encrypt($name, $this->config->item('key')),
				'trx_token_pln_pelanggan_segment' => encrypt($segment_power, $this->config->item('key')),
				'trx_token_pln_pelanggan_daya' => encrypt($daya, $this->config->item('key')),
			);

			$sess["status"] = "001";
			$sess["pesan"] = "Transaksi berhasil dan ditemukan";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));
			$sess['data'] = array(
				'token' => encrypt($keytoken, $this->config->item('keytoken')),
				'value' => encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Nomor meter/id pelanggan " . $trx_token_pln_pelanggan_nomor . " tidak ditemukan. Pastikan memasukkan nomor meter/id pelanggan yang benar!";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));
			$sess['data'] = array(
				'token' => encrypt($keytoken, $this->config->item('keytoken')),
				'value' => encrypt(json_encode([]), $keytoken)
			);
			echo json_encode($sess);
		}
	}

private function trx_token_pln_pelanggan_nomor()
{
	// 🔥 Pastikan newline dihapus sebelum proses dekripsi
	$raw_post = $this->input->post("trx_token_pln_pelanggan_nomor", true);
	$encrypted = trim(preg_replace('/\s+/', '', $raw_post)); // buang newline & spasi
	$decrypted = decrypt($encrypted, $this->config->item('key'));

	// Log untuk debugging
	log_message('info', 'Decrypted Nomor Pelanggan: ' . print_r($decrypted, true));

	// Validasi format dasar
	if (!is_numeric($decrypted) || strlen($decrypted) < 11) {
		$sess["status"] = "004";
		$sess["pesan"] = "Format nomor pelanggan tidak valid!";
		$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));
		$sess['data'] = array(
			'token' => encrypt($keytoken, $this->config->item('keytoken')),
			'value' => encrypt(json_encode([]), $keytoken)
		);
		echo json_encode($sess);
		return false;
	}

	// Validasi token
	try {
		$token = AUTHORIZATION::generateToken($decrypted);
		$data = AUTHORIZATION::validateToken($token);
		if ($data === false) throw new Exception("Token tidak valid.");
		return $data;
	} catch (Exception $e) {
		$sess["status"] = "004";
		$sess["pesan"] = $this->config->item('error_parameter');
		$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));
		$sess['data'] = array(
			'token' => encrypt($keytoken, $this->config->item('keytoken')),
			'value' => encrypt(json_encode([]), $keytoken)
		);
		echo json_encode($sess);
		return false;
	}
}

}
