<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_token_pln_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$token_pln = $this->db->query("SELECT * FROM tbl_mst_token_pln order by mst_token_pln_urutan asc");

		if ($token_pln->num_rows() > 0) {
			foreach ($token_pln->result() as $row) {
				$data['token_pln'][] = array(
					'mst_token_pln_kode' => encrypt($row->mst_token_pln_kode, $this->config->item('key')),
					'mst_token_pln_nama' => encrypt($row->mst_token_pln_nama, $this->config->item('key')),
					'mst_token_pln_keterangan' => encrypt($row->mst_token_pln_keterangan, $this->config->item('key')),
					'mst_token_pln_notasi' => encrypt($row->mst_token_pln_notasi, $this->config->item('key')),
					'mst_token_pln_harga' => encrypt(number_format($row->mst_token_pln_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_token_pln_admin' => encrypt(number_format($row->mst_token_pln_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_token_pln_total' => encrypt(number_format($row->mst_token_pln_harga + $row->mst_token_pln_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_token_pln_poin' => encrypt($row->mst_token_pln_poin, $this->config->item('key')),
					'mst_token_pln_urutan' => encrypt($row->mst_token_pln_urutan, $this->config->item('key')),
					'mst_token_pln_status' => encrypt($row->mst_token_pln_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
