<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_tapcash_activity_transaksi extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
		$this->methods['index_post']['limit_transaksi'] = 1;
	}

	private $str_mst_user_zona_waktu;
	private $str_mst_user_kode;
	private $str_mst_tapcash_kode;
	private $str_trx_tapcash_nomor;
	private $str_trx_tapcash_nama;
	private $str_trx_tapcash_admin;
	private $str_trx_tapcash_harga;
	private $str_trx_tapcash_poin;
	private $str_trx_tapcash_keterangan;
	private $str_trx_tapcash_notasi;

	public function index_post()
	{
		$this->transaksi_tapcash();

		//TIME ZONE
		date_default_timezone_set($this->str_mst_user_zona_waktu);

		//USER
		$mst_user_kode = $this->str_mst_user_kode;

		//tapcash
		$mst_tapcash_kode = $this->str_mst_tapcash_kode;

		//TRANSAKSI
		$trx_tapcash_kode =  "TAPCASH-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
		$trx_tapcash_tanggal = date('Y-m-d H:i:s');
		$trx_tapcash_nomor = $this->str_trx_tapcash_nomor;
		$trx_tapcash_nama = $this->str_trx_tapcash_nama;
		$trx_tapcash_admin = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->str_trx_tapcash_admin);
		$trx_tapcash_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->str_trx_tapcash_harga);
		$trx_tapcash_total = $trx_tapcash_harga + $trx_tapcash_admin;
		$trx_tapcash_poin = $this->str_trx_tapcash_poin;
		$trx_tapcash_keterangan = $this->str_trx_tapcash_keterangan;
		$trx_tapcash_notasi = $this->str_trx_tapcash_notasi;
		$trx_tapcash_icon = $this->config->item('icon_tapcash');

		//KATEGORI TRANSAKSI
		$trx_transaksi_kategori =  $this->config->item('transaksi_tapcash');

		//CEK SALDO
		$saldo = $this->db->query("SELECT * FROM tbl_mst_saldo WHERE 
									mst_saldo_user_kode='$mst_user_kode' and 
									mst_saldo_jumlah >= '$trx_tapcash_total'");
		if ($saldo->num_rows() > 0) {
			//SALDO CUKUP
			//DIGIFLAZZ
			$url = $this->config->item('digiflazz_api_url');
			$header = array(
				'Content-Type: text/plain',
			);
			$params = array(
				'username' => $this->config->item('digiflazz_api_username'),
				'buyer_sku_code' => $mst_tapcash_kode,
				'customer_no' => $trx_tapcash_nomor,
				'ref_id' => $trx_tapcash_kode,
				'testing' => $this->config->item('digiflazz_api_testing'),
				'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . $trx_tapcash_kode)
			);
			$json = json_encode($params);
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
			curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$result = curl_exec($ch);
			curl_close($ch);
			$response = json_decode($result, true)['data'];

			if (!empty($response['rc'])) {
				//DIGIFLAZZ
				$rc = $response['rc'];
				$status = $response['status'];
				$sn = $response['sn'];

				//TRANSAKSI SUKSES
				if ($rc == "03") {
					//INSERT KE tbl_trx_tapcash
					$this->db->query("insert into tbl_trx_tapcash (
								trx_tapcash_kode, 
								trx_tapcash_user_kode, 
								trx_tapcash_nomor, 
								trx_tapcash_nama, 
								trx_tapcash_admin,
								trx_tapcash_harga,
								trx_tapcash_poin,
								trx_tapcash_sn, 
								trx_tapcash_keterangan, 
								trx_tapcash_notasi, 
								trx_tapcash_tanggal,
								trx_tapcash_icon, 
								trx_tapcash_rc,
								trx_tapcash_status) values (
								'$trx_tapcash_kode', 
								'$mst_user_kode', 
								'$trx_tapcash_nomor', 
								'$trx_tapcash_nama', 
								'$trx_tapcash_admin',
								'$trx_tapcash_harga', 
								'$trx_tapcash_poin', 
								'$sn', 
								'$trx_tapcash_keterangan', 
								'Transaksi masih pending, cek status transaksi secara berkala', 
								'$trx_tapcash_tanggal', 
								'$trx_tapcash_icon',
								'$rc',
								'$status')");

					//INSERT KE tbl_trx_transaksi
					$this->db->query("insert into tbl_trx_transaksi (
								trx_transaksi_kode, 
								trx_transaksi_user_kode, 
								trx_transaksi_kategori, 
								trx_transaksi_nomor, 
								trx_transaksi_nama, 
								trx_transaksi_jumlah,
								trx_transaksi_keterangan,
								trx_transaksi_notasi, 
								trx_transaksi_tanggal, 
								trx_transaksi_icon, 
								trx_transaksi_rc,
								trx_transaksi_status) values (
								'$trx_tapcash_kode', 
								'$mst_user_kode', 
								'$trx_transaksi_kategori', 
								'$trx_tapcash_nomor',
								'$trx_tapcash_nama', 
								'$trx_tapcash_total', 
								'$trx_tapcash_keterangan',
								'Transaksi masih pending, cek status transaksi secara berkala ',  
								'$trx_tapcash_tanggal', 
								'$trx_tapcash_icon', 
								'$rc', 
								'$status')");

					//UPDATE tbl_mst_saldo
					$this->db->query("UPDATE tbl_mst_saldo set 
									mst_saldo_jumlah=mst_saldo_jumlah - '$trx_tapcash_total'
									where
									mst_saldo_user_kode='$mst_user_kode'");

					//PANGGIL tapcash
					$tapcash = $this->db->query("SELECT * FROM tbl_trx_tapcash 
											WHERE 
											trx_tapcash_kode='$trx_tapcash_kode' and 
											trx_tapcash_user_kode='$mst_user_kode'");
					if ($tapcash->num_rows() > 0) {
						foreach ($tapcash->result() as $row) {
							$data['transaksi'][] = array(
								'trx_tapcash_kode' => encrypt($row->trx_tapcash_kode, $this->config->item('key')),
							);
						}

						//BERHASIL
						$sess["status"] = "11";
						$sess["pesan"] = "Transaksi berhasil dan ditemukan. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
						$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
						$sess['data'] = array(
							'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
							'value' =>  encrypt(json_encode($data), $keytoken)
						);
						echo json_encode($sess);
					} else {
						//BERHASIL TAPI GAGAL MEMANGGIL
						$sess["status"] = "22";
						$sess["pesan"] = "Transaksi berhasil dilakukan. Pergi ke riwayat transaksi untuk melihat detail transaksi kamu";
						$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
						$sess['data'] = array(
							'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
							'value' =>  encrypt(json_encode(array()), $keytoken)
						);
						echo json_encode($sess);
					}
				} else {
					//GAGAL
					$sess["status"] = "33";
					$sess["pesan"] = $rc . " Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
					$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
					$sess['data'] = array(
						'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
						'value' =>  encrypt(json_encode(array()), $keytoken)
					);
					echo json_encode($sess);
				}
			} else {
				//GAGAL
				$sess["status"] = "34";
				$sess["pesan"] = "Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}
		} else {
			//SALDO TIDAK CUKUP
			$sess["status"] = "35";
			$sess["pesan"] = "Saldo kamu tidak cukup. Pastikan saldo kamu cukup sebelum melakukan transaksi";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function transaksi_tapcash()
	{

		$input = decrypt($this->input->post("transaksi_tapcash", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				$array = explode(".....", $data);
				$mst_transaksi = "";
				foreach ($array as $item) {
					$itemArray = explode(":", $item);
					$key = decrypt(trim($itemArray[0]), $this->config->item('key'));
					$value = trim($itemArray[1]);

					//AMBIL KEY TRANSAKSI
					if ($key == 'mst_transaksi') {
						$mst_transaksi = $value;
					}

					//GENERATE POST SELAIN KEY TRANSAKSI
					if ($key != 'mst_transaksi') {
						$this->transaksi_tapcash_request($key, $mst_transaksi, $value);
					}
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function transaksi_tapcash_request($key, $mst_transaksi, $value)
	{
		$transaksi = decrypt($mst_transaksi, $this->config->item('key'));
		$input = decrypt($value, $transaksi);
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				if ($key == 'mst_user_kode') {
					return $this->str_mst_user_kode = $data;
				}

				if ($key == 'mst_user_zona_waktu') {
					return $this->str_mst_user_zona_waktu = $data;
				}

				if ($key == 'mst_tapcash_kode') {
					return $this->str_mst_tapcash_kode = $data;
				}

				if ($key == 'trx_tapcash_nomor') {
					return $this->str_trx_tapcash_nomor = $data;
				}

				if ($key == 'trx_tapcash_nama') {
					return $this->str_trx_tapcash_nama = $data;
				}

				if ($key == 'trx_tapcash_admin') {
					return $this->str_trx_tapcash_admin = $data;
				}

				if ($key == 'trx_tapcash_harga') {
					return $this->str_trx_tapcash_harga = $data;
				}

				if ($key == 'trx_tapcash_poin') {
					return $this->str_trx_tapcash_poin = $data;
				}

				if ($key == 'trx_tapcash_keterangan') {
					return $this->str_trx_tapcash_keterangan = $data;
				}

				if ($key == 'trx_tapcash_notasi') {
					return $this->str_trx_tapcash_notasi = $data;
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
