<?php
// File: api/application/controllers/splash_activity/v1/Api_splash_activity.php
// Konfigurasi routes (application/config/routes.php):
// $route['api/splash_activity/v1/splash']            = 'splash_activity/v1/Api_splash_activity/index';
// $route['api/splash_activity/v1/Api_splash_activity'] = 'splash_activity/v1/Api_splash_activity/index';

defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * API untuk konfigurasi splash screen dengan logging detil
 */
class Api_splash_activity extends CI_Controller
{
    private $uploadDir;
    private $startTime;

    public function __construct()
    {
        parent::__construct();
        // Mulai timer dan log memori
        $this->startTime = microtime(true);
        log_message('debug', "[SplashAPI] __construct start, memory_awal=" . memory_get_usage());

        // Load dependencies
        $this->load->helper(['url', 'file']);
        log_message('debug', '[SplashAPI] Helpers loaded: url, file');

        $this->load->library('encryption');
        log_message('debug', '[SplashAPI] Encryption library loaded');

        $this->load->model('splash_activity/v1/Splash_model');
        log_message('debug', '[SplashAPI] Model Splash_model loaded');

        // Set upload directory
        $this->uploadDir = FCPATH . 'admin/assets/upload/data-splash/';
        log_message('debug', '[SplashAPI] uploadDir set to: ' . $this->uploadDir);
    }

    /**
     * Remap all requests to index()
     */
    public function _remap($method, $params = [])
    {
        log_message('debug', "[SplashAPI] _remap called for method: $method");
        return call_user_func_array([$this, 'index'], $params);
    }

    /**
     * GET /api/splash_activity/v1/splash
     */
    public function index()
    {
        $this->_set_json_header();
        log_message('info', '[SplashAPI] index called');

        // Validate HTTP method
        $method = $this->input->method();
        log_message('debug', '[SplashAPI] HTTP method: ' . $method);
        if ($method !== 'get') {
            log_message('warning', '[SplashAPI] Invalid method: ' . $method);
            return $this->_response('004', 'Method tidak diizinkan');
        }

        try {
            // Fetch latest splash data
            $row = $this->Splash_model->get_latest();
            log_message('debug', '[SplashAPI] Splash_model::get_latest returned: ' . print_r($row, true));
            if (!$row) {
                log_message('error', '[SplashAPI] No data found');
                throw new Exception('Data tidak ditemukan');
            }

            // Validate required fields
            foreach (['splash_version', 'splash_url', 'splash_time'] as $col) {
                $val = isset($row->$col) ? var_export($row->$col, true) : 'unset';
                log_message('debug', "[SplashAPI] Validating $col: $val");
                if (!isset($row->$col) || $row->$col === '' || $row->$col === null) {
                    log_message('error', "[SplashAPI] Invalid $col: $val");
                    throw new Exception("Kolom $col tidak valid");
                }
            }

            // Verify file existence
            $filePath = $this->uploadDir . $row->splash_url;
            log_message('debug', '[SplashAPI] Checking file: ' . $filePath);
            if (!file_exists($filePath)) {
                log_message('error', '[SplashAPI] File not found: ' . $filePath);
                throw new Exception('File tidak ditemukan: ' . $row->splash_url);
            }

            // Build payload
            $publicUrl = rtrim(base_url(), '/') . '/admin/assets/upload/data-splash/' . $row->splash_url;
            $payload = [
                'version'       => (int)$row->splash_version,
                'url'           => $publicUrl,
                'displayTimeMs' => (int)$row->splash_time,
            ];
            log_message('debug', '[SplashAPI] Payload: ' . json_encode($payload));

            // Encrypt payload
            $keytoken = strtoupper(substr(sha1(uniqid('', true)), 0, 16));
            log_message('debug', '[SplashAPI] Generated keytoken: ' . $keytoken);

            $this->encryption->initialize(['cipher' => 'aes-256', 'key' => $keytoken]);
            log_message('debug', '[SplashAPI] Encryption initialized with custom key');
            $encValue = $this->encryption->encrypt(json_encode($payload));
            log_message('debug', '[SplashAPI] encValue: ' . $encValue);

            // Encrypt keytoken with default key
            $this->encryption->initialize();
            $encKey = $this->encryption->encrypt($keytoken);
            log_message('debug', '[SplashAPI] encKey: ' . $encKey);

            // Log execution time
            $duration = round(microtime(true) - $this->startTime, 4);
            log_message('info', "[SplashAPI] Execution time: {$duration}s");

            // Send response
            return $this->_response('001', 'Splash data tersedia', [
                'data' => [
                    'token' => $encKey,
                    'value' => $encValue
                ]
            ]);
        } catch (Exception $e) {
            log_message('error', '[SplashAPI] Exception: ' . $e->getMessage());
            return $this->_response('005', 'Error server: ' . $e->getMessage());
        }
    }
}