<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_pulsa_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$mst_pulsa_operator = $this->mst_pulsa_operator();

		//PANGGIL DATA
		$pulsa = $this->db->query("SELECT * FROM tbl_mst_pulsa WHERE mst_pulsa_operator='$mst_pulsa_operator' order by mst_pulsa_urutan asc");

		if ($pulsa->num_rows() > 0) {
			foreach ($pulsa->result() as $row) {
				$data['pulsa'][] = array(
					'mst_pulsa_kode' => encrypt($row->mst_pulsa_kode, $this->config->item('key')),
					'mst_pulsa_operator' => encrypt($row->mst_pulsa_operator, $this->config->item('key')),
					'mst_pulsa_nama' => encrypt($row->mst_pulsa_nama, $this->config->item('key')),
					'mst_pulsa_keterangan' => encrypt($row->mst_pulsa_keterangan, $this->config->item('key')),
					'mst_pulsa_notasi' => encrypt($row->mst_pulsa_notasi, $this->config->item('key')),
					'mst_pulsa_harga' => encrypt(number_format($row->mst_pulsa_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_pulsa_admin' => encrypt(number_format($row->mst_pulsa_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_pulsa_total' => encrypt(number_format($row->mst_pulsa_harga + $row->mst_pulsa_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_pulsa_poin' => encrypt($row->mst_pulsa_poin, $this->config->item('key')),
					'mst_pulsa_urutan' => encrypt($row->mst_pulsa_urutan, $this->config->item('key')),
					'mst_pulsa_status' => encrypt($row->mst_pulsa_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_pulsa_operator()
	{
		$input = decrypt($this->input->post("mst_pulsa_operator", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
