<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_pbb_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PBB
		$trx_pbb_kode =  "PBB-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
		$trx_pbb_kategori_kode = $this->trx_pbb_kategori_kode();
		$trx_pbb_kategori_nama = $this->trx_pbb_kategori_nama();
		$trx_pbb_nomor = $this->trx_pbb_nomor();

		//DIGIFLAZZ
		$url = $this->config->item('digiflazz_api_url');
		$header = array(
			'Content-Type: text/plain',
		);
		$params = array(
			'commands' => 'inq-pasca',
			'username' => $this->config->item('digiflazz_api_username'),
			'buyer_sku_code' => $trx_pbb_kategori_kode,
			'customer_no' => $trx_pbb_nomor,
			'ref_id' => $trx_pbb_kode,
			'testing' => $this->config->item('digiflazz_api_testing'),
			'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . $trx_pbb_kode)
		);
		$json = json_encode($params);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$result = curl_exec($ch);
		curl_close($ch);
		$response = json_decode($result, true)['data'];

		if (!empty($response['rc'])) {
			//DIGIFLAZZ
			$rc = $response['rc'];
			$message = $response['message'];
			$customer_no = $response['customer_no'];
			$customer_name = ucwords(strtolower($response['customer_name']));
			$admin = $this->config->item('admin_pbb');
			$selling_price = $response['selling_price'];
			$total = $admin + $selling_price;
			$desc = $response['desc'];
			$lembar_tagihan = $desc['lembar_tagihan'];
			$alamat = ucwords(strtolower($desc['alamat']));
			$tahun_pajak = $desc['tahun_pajak'];
			$kelurahan = ucwords(strtolower($desc['kelurahan']));
			$kecamatan = ucwords(strtolower($desc['kecamatan']));
			$kab_kota = ucwords(strtolower($desc['kab_kota']));
			$luas_tanah = $desc['luas_tanah'];
			$luas_gedung = $desc['luas_gedung'];




			//SUKSES
			if ($rc == "00") {
				$data['pbb'][] = array(
					'trx_pbb_kode' => encrypt($trx_pbb_kode, $this->config->item('key')),
					'trx_pbb_kategori_kode' => encrypt($trx_pbb_kategori_kode, $this->config->item('key')),
					'trx_pbb_kategori_nama' => encrypt($trx_pbb_kategori_nama, $this->config->item('key')),
					'trx_pbb_nomor' => encrypt($customer_no, $this->config->item('key')),
					'trx_pbb_nama' => encrypt($customer_name, $this->config->item('key')),
					'trx_pbb_alamat' => encrypt($alamat, $this->config->item('key')),
					'trx_pbb_kelurahan' => encrypt($kelurahan, $this->config->item('key')),
					'trx_pbb_kecamatan' => encrypt($kecamatan, $this->config->item('key')),
					'trx_pbb_kota' => encrypt($kab_kota, $this->config->item('key')),
					'trx_pbb_luas_tanah' => encrypt($luas_tanah, $this->config->item('key')),
					'trx_pbb_luas_bangunan' => encrypt($luas_gedung, $this->config->item('key')),
					'trx_pbb_admin' => encrypt(number_format($admin, 0, ',', '.'), $this->config->item('key')),
					'trx_pbb_harga' => encrypt(number_format($selling_price, 0, ',', '.'), $this->config->item('key')),
					'trx_pbb_total' => encrypt(number_format($total, 0, ',', '.'), $this->config->item('key')),
					'trx_pbb_lembar_tagihan' => encrypt($lembar_tagihan, $this->config->item('key')),
					'trx_pbb_tahun' => encrypt($tahun_pajak, $this->config->item('key')),
					'trx_pbb_keterangan' => encrypt("-", $this->config->item('key')),
					'trx_pbb_notasi' => encrypt("-", $this->config->item('key')),
				);

				//BERHASIL
				$sess["status"] = "11";
				$sess["pesan"] = "Transaksi berhasil dan ditemukan";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode($data), $keytoken)
				);
				echo json_encode($sess);
			} else if ($rc == "60") {
				//TAGIHAN BELUM ADA
				$sess["status"] = "22";
				$sess["pesan"] = $rc . " Tagihan belum tersedia untuk " . $trx_pbb_nomor . " Mohon dicek lagi secara berkala dan pastikan nomor yang kamu masukkan sudah benar.";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			} else {
				//GAGAL
				$sess["status"] = "33";
				$sess["pesan"] = $rc . " Transaksi gagal. Silahkan laporkan pesan tersebut ke customer service jika ada pertanyaan lebih lanjut.";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}
		} else {
			//GAGAL
			$sess["status"] = "34";
			$sess["pesan"] = "Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function trx_pbb_nomor()
	{
		$input = decrypt($this->input->post("trx_pbb_nomor", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_pbb_kategori_kode()
	{
		$input = decrypt($this->input->post("trx_pbb_kategori_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_pbb_kategori_nama()
	{
		$input = decrypt($this->input->post("trx_pbb_kategori_nama", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
