<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_pbb_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//PBB
		$trx_pbb_kode = $this->trx_pbb_kode();

		//PANGGIL PBB
		$game = $this->db->query("SELECT * FROM tbl_trx_pbb 
									WHERE 
									trx_pbb_kode='$trx_pbb_kode' and 
									trx_pbb_user_kode='$mst_user_kode'");
		if ($game->num_rows() > 0) {
			foreach ($game->result() as $row) {
				$data['transaksi'][] = array(
					'trx_pbb_kode' => encrypt($row->trx_pbb_kode, $this->config->item('key')),
					'trx_pbb_user_kode' => encrypt($row->trx_pbb_user_kode, $this->config->item('key')),
					'trx_pbb_kategori_kode' => encrypt($row->trx_pbb_kategori_kode, $this->config->item('key')),
					'trx_pbb_kategori_nama' => encrypt($row->trx_pbb_kategori_nama, $this->config->item('key')),
					'trx_pbb_nomor' => encrypt($row->trx_pbb_nomor, $this->config->item('key')),
					'trx_pbb_nama' => encrypt($row->trx_pbb_nama, $this->config->item('key')),
					'trx_pbb_alamat' => encrypt($row->trx_pbb_alamat, $this->config->item('key')),
					'trx_pbb_kelurahan' => encrypt($row->trx_pbb_kelurahan, $this->config->item('key')),
					'trx_pbb_kecamatan' => encrypt($row->trx_pbb_kecamatan, $this->config->item('key')),
					'trx_pbb_kota' => encrypt($row->trx_pbb_kota, $this->config->item('key')),
					'trx_pbb_luas_tanah' => encrypt($row->trx_pbb_luas_tanah, $this->config->item('key')),
					'trx_pbb_luas_bangunan' => encrypt($row->trx_pbb_luas_bangunan, $this->config->item('key')),
					'trx_pbb_admin' => encrypt(number_format($row->trx_pbb_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_pbb_harga' => encrypt(number_format($row->trx_pbb_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_pbb_total' => encrypt(number_format($row->trx_pbb_admin + $row->trx_pbb_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_pbb_lembar_tagihan' => encrypt($row->trx_pbb_lembar_tagihan, $this->config->item('key')),
					'trx_pbb_tahun' => encrypt($row->trx_pbb_tahun, $this->config->item('key')),
					'trx_pbb_sn' => encrypt($row->trx_pbb_sn, $this->config->item('key')),
					'trx_pbb_keterangan' => encrypt($row->trx_pbb_keterangan, $this->config->item('key')),
					'trx_pbb_notasi' => encrypt($row->trx_pbb_notasi, $this->config->item('key')),
					'trx_pbb_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_pbb_tanggal)), $this->config->item('key')),
					'trx_pbb_icon' => encrypt($row->trx_pbb_icon, $this->config->item('key')),
					'trx_pbb_rc' => encrypt($row->trx_pbb_rc, $this->config->item('key')),
					'trx_pbb_status' => encrypt($row->trx_pbb_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_pbb_kode()
	{
		$input = decrypt($this->input->post("trx_pbb_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
