<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_multifinance_activity_riwayat extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//PAGING
		$page_number = $this->input->post("page_number", true);
		$paging = $page_number * 20 - (20);
		if ($paging == '1') {
			$paging = 0;
		}

		//FILTER
		$trx_multifinance_tanggal_awal = $this->trx_multifinance_tanggal_awal();
		$trx_multifinance_tanggal_akhir = $this->trx_multifinance_tanggal_akhir();

		//FILTER
		if (strlen($trx_multifinance_tanggal_awal) > 1 && strlen($trx_multifinance_tanggal_akhir) > 1) {
			//PANGGIL DATA
			$multifinance = $this->db->query("SELECT * FROM tbl_trx_multifinance WHERE 
								trx_multifinance_user_kode='$mst_user_kode' AND
								trx_multifinance_tanggal BETWEEN '$trx_multifinance_tanggal_awal 00:00:00' and '$trx_multifinance_tanggal_akhir 23:59:59'
								ORDER BY trx_multifinance_id desc
								limit 20 offset $paging");
		} else {
			//PANGGIL DATA
			$multifinance = $this->db->query("SELECT * FROM tbl_trx_multifinance WHERE 
								trx_multifinance_user_kode='$mst_user_kode'
								ORDER BY trx_multifinance_id desc
								limit 20 offset $paging");
		}

		if ($multifinance->num_rows() > 0) {
			foreach ($multifinance->result() as $row) {
				$data['riwayat'][] = array(
					'trx_multifinance_kode' => encrypt($row->trx_multifinance_kode, $this->config->item('key')),
					'trx_multifinance_user_kode' => encrypt($row->trx_multifinance_user_kode, $this->config->item('key')),
					'trx_multifinance_kategori_kode' => encrypt($row->trx_multifinance_kategori_kode, $this->config->item('key')),
					'trx_multifinance_kategori_nama' => encrypt($row->trx_multifinance_kategori_nama, $this->config->item('key')),
					'trx_multifinance_nomor' => encrypt($row->trx_multifinance_nomor, $this->config->item('key')),
					'trx_multifinance_nama' => encrypt($row->trx_multifinance_nama, $this->config->item('key')),
					'trx_multifinance_admin' => encrypt(number_format($row->trx_multifinance_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_multifinance_harga' => encrypt(number_format($row->trx_multifinance_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_multifinance_total' => encrypt(number_format($row->trx_multifinance_admin + $row->trx_multifinance_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_multifinance_lembar_tagihan' => encrypt($row->trx_multifinance_lembar_tagihan, $this->config->item('key')),
					'trx_multifinance_periode' => encrypt($row->trx_multifinance_periode, $this->config->item('key')),
					'trx_multifinance_sn' => encrypt($row->trx_multifinance_sn, $this->config->item('key')),
					'trx_multifinance_keterangan' => encrypt($row->trx_multifinance_keterangan, $this->config->item('key')),
					'trx_multifinance_notasi' => encrypt($row->trx_multifinance_notasi, $this->config->item('key')),
					'trx_multifinance_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_multifinance_tanggal)), $this->config->item('key')),
					'trx_multifinance_icon' => encrypt($row->trx_multifinance_icon, $this->config->item('key')),
					'trx_multifinance_rc' => encrypt($row->trx_multifinance_rc, $this->config->item('key')),
					'trx_multifinance_status' => encrypt($row->trx_multifinance_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal menampilkan data, silahkan refresh halaman secara berkala atau hubungi customer service jika masih terjadi kendala!";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_multifinance_tanggal_awal()
	{
		$input = decrypt($this->input->post("trx_multifinance_tanggal_awal", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_multifinance_tanggal_akhir()
	{
		$input = decrypt($this->input->post("trx_multifinance_tanggal_akhir", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
