<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_multifinance_activity_kategori extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Jakarta");
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$multifinance = $this->db->query("SELECT * FROM tbl_ktg_multifinance where ktg_multifinance_status in ('0','1') order by ktg_multifinance_urutan asc");
		if ($multifinance->num_rows() > 0) {
			foreach ($multifinance->result() as $row) {
				$data['kategori'][] = array(
					'ktg_multifinance_kode' => encrypt($row->ktg_multifinance_kode, $this->config->item('key')),
					'ktg_multifinance_nama' => encrypt($row->ktg_multifinance_nama, $this->config->item('key')),
					'ktg_multifinance_icon' => encrypt($row->ktg_multifinance_icon, $this->config->item('key')),
					'ktg_multifinance_urutan' => encrypt($row->ktg_multifinance_urutan, $this->config->item('key')),
					'ktg_multifinance_keterangan' => encrypt($row->ktg_multifinance_keterangan, $this->config->item('key')),
					'ktg_multifinance_notasi' => encrypt($row->ktg_multifinance_notasi, $this->config->item('key')),
					'ktg_multifinance_status' => encrypt($row->ktg_multifinance_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Kategori tersedia";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Kategori tidak ada";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
