<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api_request_otp extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->helper([
            'url',
            'security',
            'env_helper',
            'hash_helper',
            'key_helper',
            'fonnte_helper'
        ]);
        $this->load->model('Otp_model');
    }

    public function index()
    {
        header('Content-Type: application/json; charset=utf-8');

        // 1. Cek method POST
        if ($this->input->method() !== 'post') {
            log_message('error', '[OTP] Invalid method: ' . $this->input->method());
            echo json_encode([
                'status'     => false,
                'registered' => false,
                'message'    => 'Method tidak diizinkan'
            ]);
            return;
        }

        // 2. Ambil dan cek param
        $enc_nomor = $this->input->post('nomor_hp', false);
        log_message('debug', '[OTP] Param nomor_hp terenkripsi: ' . $enc_nomor);

        if (empty($enc_nomor)) {
            log_message('error', '[OTP] Parameter nomor_hp kosong');
            echo json_encode([
                'status'     => false,
                'registered' => false,
                'message'    => 'Parameter nomor_hp dibutuhkan'
            ]);
            return;
        }

        // 3. Dekripsi nomor
        $nomor_hp = decrypt($enc_nomor, get_key());
        log_message('debug', '[OTP] Hasil dekripsi nomor_hp: ' . $nomor_hp);

        if ($nomor_hp === false) {
            log_message('error', '[OTP] Dekripsi nomor HP gagal');
            echo json_encode([
                'status'     => false,
                'registered' => false,
                'message'    => 'Data nomor HP tidak valid'
            ]);
            return;
        }

        // 4. Validasi format
        if (!preg_match('/^(08|\+628)[0-9]{7,14}$/', $nomor_hp)) {
            log_message('error', '[OTP] Format nomor HP tidak valid: ' . $nomor_hp);
            echo json_encode([
                'status'     => false,
                'registered' => false,
                'message'    => 'Format nomor HP tidak valid'
            ]);
            return;
        }

        // 5. Cek apakah nomor terdaftar di tbl_mst_user
        $user = $this->db->get_where('tbl_mst_user', ['mst_user_nomor_hp' => $nomor_hp]);
        if ($user->num_rows() === 0) {
            log_message('error', '[OTP] Nomor tidak terdaftar: ' . $nomor_hp);
            echo json_encode([
                'status'     => false,
                'registered' => false,
                'message'    => 'Nomor tidak terdaftar'
            ]);
            return;
        }

        // 6. Hapus semua OTP lama
        $deleted = $this->Otp_model->delete_all_otp($nomor_hp);
        log_message('debug', '[OTP] Hapus OTP lama: ' . ($deleted ? 'sukses' : 'gagal'));

        // 7. Generate OTP 6 digit
        $otp_code = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
        log_message('debug', '[OTP] OTP baru: ' . $otp_code);

        // 8. Simpan OTP ke database
        $inserted = $this->Otp_model->insert_otp($nomor_hp, $otp_code);
        log_message('debug', '[OTP] Simpan ke DB: ' . ($inserted ? 'sukses' : 'gagal'));

        if (! $inserted) {
            log_message('error', '[OTP] Gagal menyimpan OTP ke database');
            echo json_encode([
                'status'     => false,
                'registered' => true,
                'message'    => 'Gagal menyimpan OTP'
            ]);
            return;
        }

        // 9. Kirim OTP via Fonnte
        $send_result = send_otp_via_fonnte($nomor_hp, $otp_code);
        log_message('debug', '[OTP] Fonnte send result: ' . json_encode($send_result));

        // 10. Response akhir
        if (!empty($send_result['success']) && $send_result['success'] === true) {
            log_message('info', '[OTP] OTP terkirim ke WhatsApp: ' . $nomor_hp);
            echo json_encode([
                'status'     => true,
                'registered' => true,
                'message'    => 'OTP terkirim'
            ]);
        } else {
            log_message('error', '[OTP] Gagal kirim via Fonnte: ' . $send_result['message']);
            echo json_encode([
                'status'     => false,
                'registered' => true,
                'message'    => 'Gagal mengirim OTP ke WhatsApp. Silakan coba lagi.',
                'error'      => $send_result['message']
            ]);
        }
    }
}
