<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_linkaja_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$linkaja = $this->db->query("SELECT * FROM tbl_mst_linkaja  order by mst_linkaja_urutan asc");

		if ($linkaja->num_rows() > 0) {
			foreach ($linkaja->result() as $row) {
				$data['linkaja'][] = array(
					'mst_linkaja_kode' => encrypt($row->mst_linkaja_kode, $this->config->item('key')),
					'mst_linkaja_nama' => encrypt($row->mst_linkaja_nama, $this->config->item('key')),
					'mst_linkaja_keterangan' => encrypt($row->mst_linkaja_keterangan, $this->config->item('key')),
					'mst_linkaja_notasi' => encrypt($row->mst_linkaja_notasi, $this->config->item('key')),
					'mst_linkaja_harga' => encrypt(number_format($row->mst_linkaja_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_linkaja_admin' => encrypt(number_format($row->mst_linkaja_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_linkaja_total' => encrypt(number_format($row->mst_linkaja_harga + $row->mst_linkaja_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_linkaja_poin' => encrypt($row->mst_linkaja_poin, $this->config->item('key')),
					'mst_linkaja_urutan' => encrypt($row->mst_linkaja_urutan, $this->config->item('key')),
					'mst_linkaja_status' => encrypt($row->mst_linkaja_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
