<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_home_activity_uang_elektronik extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Jakarta");
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$banner = $this->db->query("SELECT * FROM tbl_mst_menu where mst_menu_grup='Uang Elektronik' and mst_menu_status in ('0','1') order by mst_menu_urutan asc");
		if ($banner->num_rows() > 0) {
			foreach ($banner->result() as $row) {
				$data['menu'][] = array(
					'mst_menu_id' => encrypt($row->mst_menu_id, $this->config->item('key')),
					'mst_menu_kode' => encrypt($row->mst_menu_kode, $this->config->item('key')),
					'mst_menu_grup' => encrypt($row->mst_menu_grup, $this->config->item('key')),
					'mst_menu_nama' => encrypt($row->mst_menu_nama, $this->config->item('key')),
					'mst_menu_tipe' => encrypt($row->mst_menu_tipe, $this->config->item('key')),
					'mst_menu_link' => encrypt($row->mst_menu_link, $this->config->item('key')),
					'mst_menu_icon' => encrypt($row->mst_menu_icon, $this->config->item('key')),
					'mst_menu_urutan' => encrypt($row->mst_menu_urutan, $this->config->item('key')),
					'mst_menu_notasi' => encrypt($row->mst_menu_notasi, $this->config->item('key')),
					'mst_menu_keterangan' => encrypt($row->mst_menu_keterangan, $this->config->item('key')),
					'mst_menu_status' => encrypt($row->mst_menu_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Menu tersedia";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Menu tidak ada";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
