<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_home_activity_banner_kategori extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Jakarta");
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$banner = $this->db->query("SELECT distinct(mst_banner_kategori) AS mst_banner_kategori FROM tbl_mst_banner WHERE mst_banner_status='0'");
		if ($banner->num_rows() > 0) {
			foreach ($banner->result() as $row) {
				$data['banner'][] = array(
					'mst_banner_kategori' => encrypt($row->mst_banner_kategori, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Banner tersedia";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Banner tidak ada";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
