<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_hadiah_activity_pilihan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set($this->mst_user_zona_waktu());

		$local_tz = new DateTimeZone($this->mst_user_zona_waktu());
		$local_time = new DateTime('now', $local_tz);
		$offset = $local_tz->getOffset($local_time) / 3600;

		if ($offset == 7) {
			$trx_hadiah_tanggal = date('Y-m-d H:i:s');
		} else if ($offset == 8) {
			$trx_hadiah_tanggal = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' -1 hour'));
		} else if ($offset == 9) {
			$trx_hadiah_tanggal = date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' -2 hour'));
		} else {
			$trx_hadiah_tanggal = date('Y-m-d H:i:s');
		}

		$hadiah = $this->db->query("SELECT * FROM tbl_mst_hadiah WHERE
									mst_hadiah_periode_akhir >= '$trx_hadiah_tanggal' AND mst_hadiah_status='0'");
		if ($hadiah->num_rows() > 0) {
			foreach ($hadiah->result() as $row) {
				if (strtotime($trx_hadiah_tanggal) < strtotime($row->mst_hadiah_periode_awal)) {
					if (strtotime($row->mst_hadiah_periode_awal) > strtotime($trx_hadiah_tanggal)) {
						$selisih_detik = strtotime($row->mst_hadiah_periode_awal) - strtotime($trx_hadiah_tanggal);
						$hari = floor($selisih_detik / (60 * 60 * 24));
						$jam = floor(($selisih_detik % (60 * 60 * 24)) / (60 * 60));
						$menit = floor(($selisih_detik % (60 * 60)) / 60);
						$detik = $selisih_detik % 60;

						if ($hari >= 1) {
							$mst_hadiah_periode = date("d M Y H:i", strtotime($row->mst_hadiah_periode_awal));
						} else if ($jam >= 1) {
							$mst_hadiah_periode = "Dimulai $jam jam $menit menit lagi";
						} else if ($menit >= 1) {
							$mst_hadiah_periode = "Dimulai $menit menit lagi";
						} else if ($menit < 1) {
							$mst_hadiah_periode = "Dimulai $detik detik lagi";
						}
					}
				} else {
					if (strtotime($trx_hadiah_tanggal) < strtotime($row->mst_hadiah_periode_akhir)) {
						$selisih_detik =  strtotime($row->mst_hadiah_periode_akhir) - strtotime($trx_hadiah_tanggal);
						$hari = floor($selisih_detik / (60 * 60 * 24));
						$jam = floor(($selisih_detik % (60 * 60 * 24)) / (60 * 60));
						$menit = floor(($selisih_detik % (60 * 60)) / 60);
						$detik = $selisih_detik % 60;

						if ($hari >= 1) {
							$mst_hadiah_periode = "Berakhir " . date("d M Y H:i", strtotime($row->mst_hadiah_periode_akhir));
						} else if ($jam >= 1) {
							$mst_hadiah_periode = "Berakhir $jam jam $menit menit lagi";
						} else if ($menit >= 1) {
							$mst_hadiah_periode = "Berakhir $menit menit lagi";
						} else if ($menit < 1) {
							$mst_hadiah_periode = "Berakhir $detik detik lagi";
						}
					}
				}
				$data['hadiah'][] = array(
					'mst_hadiah_kode' => encrypt($row->mst_hadiah_kode, $this->config->item('key')),
					'mst_hadiah_nama' => encrypt($row->mst_hadiah_nama, $this->config->item('key')),
					'mst_hadiah_jenis' => encrypt($row->mst_hadiah_jenis, $this->config->item('key')),
					'mst_hadiah_harga' => encrypt(number_format($row->mst_hadiah_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_hadiah_sisa' => encrypt(number_format($row->mst_hadiah_stok - $row->mst_hadiah_terpakai, 0, ',', '.'), $this->config->item('key')),
					'mst_hadiah_periode' => encrypt($mst_hadiah_periode, $this->config->item('key')),
					'mst_hadiah_foto' => encrypt($row->mst_hadiah_foto, $this->config->item('key')),
					'mst_hadiah_keterangan' => encrypt($row->mst_hadiah_keterangan, $this->config->item('key')),
					'mst_hadiah_status' => encrypt($row->mst_hadiah_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}

	private function mst_user_zona_waktu()
	{
		$input = decrypt($this->input->post("mst_user_zona_waktu", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
