<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_grab_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//GRAB
		$trx_grab_kode = $this->trx_grab_kode();

		//PANGGIL GRAB
		$grab = $this->db->query("SELECT * FROM tbl_trx_grab 
									WHERE 
									trx_grab_kode='$trx_grab_kode' and 
									trx_grab_user_kode='$mst_user_kode'");
		if ($grab->num_rows() > 0) {
			foreach ($grab->result() as $row) {
				$data['transaksi'][] = array(
					'trx_grab_kode' => encrypt($row->trx_grab_kode, $this->config->item('key')),
					'trx_grab_user_kode' => encrypt($row->trx_grab_user_kode, $this->config->item('key')),
					'trx_grab_nomor' => encrypt($row->trx_grab_nomor, $this->config->item('key')),
					'trx_grab_nama' => encrypt($row->trx_grab_nama, $this->config->item('key')),
					'trx_grab_admin' => encrypt(number_format($row->trx_grab_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_grab_harga' => encrypt(number_format($row->trx_grab_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_grab_total' => encrypt(number_format($row->trx_grab_admin + $row->trx_grab_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_grab_poin' => encrypt($row->trx_grab_poin, $this->config->item('key')),
					'trx_grab_sn' => encrypt($row->trx_grab_sn, $this->config->item('key')),
					'trx_grab_keterangan' => encrypt($row->trx_grab_keterangan, $this->config->item('key')),
					'trx_grab_notasi' => encrypt($row->trx_grab_notasi, $this->config->item('key')),
					'trx_grab_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_grab_tanggal)), $this->config->item('key')),
					'trx_grab_icon' => encrypt($row->trx_grab_icon, $this->config->item('key')),
					'trx_grab_rc' => encrypt($row->trx_grab_rc, $this->config->item('key')),
					'trx_grab_status' => encrypt($row->trx_grab_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_grab_kode()
	{
		$input = decrypt($this->input->post("trx_grab_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
