<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_gopay_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$gopay = $this->db->query("SELECT * FROM tbl_mst_gopay  order by mst_gopay_urutan asc");

		if ($gopay->num_rows() > 0) {
			foreach ($gopay->result() as $row) {
				$data['gopay'][] = array(
					'mst_gopay_kode' => encrypt($row->mst_gopay_kode, $this->config->item('key')),
					'mst_gopay_nama' => encrypt($row->mst_gopay_nama, $this->config->item('key')),
					'mst_gopay_keterangan' => encrypt($row->mst_gopay_keterangan, $this->config->item('key')),
					'mst_gopay_notasi' => encrypt($row->mst_gopay_notasi, $this->config->item('key')),
					'mst_gopay_harga' => encrypt(number_format($row->mst_gopay_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_gopay_admin' => encrypt(number_format($row->mst_gopay_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_gopay_total' => encrypt(number_format($row->mst_gopay_harga + $row->mst_gopay_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_gopay_poin' => encrypt($row->mst_gopay_poin, $this->config->item('key')),
					'mst_gopay_urutan' => encrypt($row->mst_gopay_urutan, $this->config->item('key')),
					'mst_gopay_status' => encrypt($row->mst_gopay_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
