<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_game_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$mst_game_kategori = $this->mst_game_kategori();

		//PANGGIL DATA
		$game = $this->db->query("SELECT * FROM tbl_mst_game WHERE mst_game_kategori='$mst_game_kategori' order by mst_game_urutan asc");

		if ($game->num_rows() > 0) {
			foreach ($game->result() as $row) {
				$data['game'][] = array(
					'mst_game_kode' => encrypt($row->mst_game_kode, $this->config->item('key')),
					'mst_game_kategori' => encrypt($row->mst_game_kategori, $this->config->item('key')),
					'mst_game_nama' => encrypt($row->mst_game_nama, $this->config->item('key')),
					'mst_game_keterangan' => encrypt($row->mst_game_keterangan, $this->config->item('key')),
					'mst_game_notasi' => encrypt($row->mst_game_notasi, $this->config->item('key')),
					'mst_game_harga' => encrypt(number_format($row->mst_game_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_game_admin' => encrypt(number_format($row->mst_game_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_game_total' => encrypt(number_format($row->mst_game_harga + $row->mst_game_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_game_poin' => encrypt($row->mst_game_poin, $this->config->item('key')),
					'mst_game_urutan' => encrypt($row->mst_game_urutan, $this->config->item('key')),
					'mst_game_status' => encrypt($row->mst_game_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_game_kategori()
	{
		$input = decrypt($this->input->post("mst_game_kategori", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
