<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_game_activity_kategori extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Jakarta");
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$game = $this->db->query("SELECT * FROM tbl_ktg_game where ktg_game_status in ('0','1') order by ktg_game_urutan asc");
		if ($game->num_rows() > 0) {
			foreach ($game->result() as $row) {
				$data['kategori'][] = array(
					'ktg_game_kode' => encrypt($row->ktg_game_kode, $this->config->item('key')),
					'ktg_game_nama' => encrypt($row->ktg_game_nama, $this->config->item('key')),
					'ktg_game_icon' => encrypt($row->ktg_game_icon, $this->config->item('key')),
					'ktg_game_urutan' => encrypt($row->ktg_game_urutan, $this->config->item('key')),
					'ktg_game_keterangan' => encrypt($row->ktg_game_keterangan, $this->config->item('key')),
					'ktg_game_notasi' => encrypt($row->ktg_game_notasi, $this->config->item('key')),
					'ktg_game_status' => encrypt($row->ktg_game_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Kategori tersedia";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Kategori tidak ada";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
