<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_downline_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$mst_user_kode =  $this->mst_user_kode();

		//PANGGIL DATA
		$downline = $this->db->query("SELECT mst_poin_user_kode, 
									mst_user_nama_lengkap,
									mst_user_nomor_hp,
									mst_user_email,
									mst_poin_jumlah FROM tbl_mst_user, tbl_mst_poin  
									where mst_poin_user_kode=mst_user_kode
									and mst_user_upline = '$mst_user_kode'
									order by mst_poin_jumlah desc");

		if ($downline->num_rows() > 0) {
			$no = 1;
			foreach ($downline->result() as $row) {
				$data['downline'][] = array(
					'nomor' => encrypt($no, $this->config->item('key')),
					'mst_user_nama_lengkap' => encrypt($row->mst_user_nama_lengkap, $this->config->item('key')),
					'mst_user_nomor_hp' => encrypt($this->simbol($row->mst_user_nomor_hp), $this->config->item('key')),
					'mst_user_email' => encrypt($this->simbol($row->mst_user_email), $this->config->item('key')),
					'mst_poin_jumlah' => encrypt(number_format($row->mst_poin_jumlah, 0, ',', '.'), $this->config->item('key')),
				);
				$no++;
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}

	private function simbol($string)
	{
		$length = strlen($string);
		$asterisks = str_repeat("*", $length / 2);

		$markedString = str_replace(str_split(substr($string, $length - strlen($asterisks), strlen($asterisks))), str_split($asterisks), $string);

		return $markedString;
	}

	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
