<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_doku_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//DOKU
		$trx_doku_kode = $this->trx_doku_kode();

		//PANGGIL DOKU
		$doku = $this->db->query("SELECT * FROM tbl_trx_doku 
									WHERE 
									trx_doku_kode='$trx_doku_kode' and 
									trx_doku_user_kode='$mst_user_kode'");
		if ($doku->num_rows() > 0) {
			foreach ($doku->result() as $row) {
				$data['transaksi'][] = array(
					'trx_doku_kode' => encrypt($row->trx_doku_kode, $this->config->item('key')),
					'trx_doku_user_kode' => encrypt($row->trx_doku_user_kode, $this->config->item('key')),
					'trx_doku_nomor' => encrypt($row->trx_doku_nomor, $this->config->item('key')),
					'trx_doku_nama' => encrypt($row->trx_doku_nama, $this->config->item('key')),
					'trx_doku_admin' => encrypt(number_format($row->trx_doku_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_doku_harga' => encrypt(number_format($row->trx_doku_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_doku_total' => encrypt(number_format($row->trx_doku_admin + $row->trx_doku_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_doku_poin' => encrypt($row->trx_doku_poin, $this->config->item('key')),
					'trx_doku_sn' => encrypt($row->trx_doku_sn, $this->config->item('key')),
					'trx_doku_keterangan' => encrypt($row->trx_doku_keterangan, $this->config->item('key')),
					'trx_doku_notasi' => encrypt($row->trx_doku_notasi, $this->config->item('key')),
					'trx_doku_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_doku_tanggal)), $this->config->item('key')),
					'trx_doku_icon' => encrypt($row->trx_doku_icon, $this->config->item('key')),
					'trx_doku_rc' => encrypt($row->trx_doku_rc, $this->config->item('key')),
					'trx_doku_status' => encrypt($row->trx_doku_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_doku_kode()
	{
		$input = decrypt($this->input->post("trx_doku_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
