<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_deposit_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//DEPOSIT
		$trx_deposit_kode = $this->trx_deposit_kode();

		//PANGGIL DEPOSIT
		$deposit = $this->db->query("SELECT * FROM tbl_trx_deposit 
									WHERE 
									trx_deposit_kode='$trx_deposit_kode' and 
									trx_deposit_user_kode='$mst_user_kode'");
		if ($deposit->num_rows() > 0) {
			foreach ($deposit->result() as $row) {
				$data['transaksi'][] = array(
					'trx_deposit_kode' => encrypt($row->trx_deposit_kode, $this->config->item('key')),
					'trx_deposit_user_kode' => encrypt($row->trx_deposit_user_kode, $this->config->item('key')),
					'trx_deposit_tripay_reference' => encrypt($row->trx_deposit_tripay_reference, $this->config->item('key')),
					'trx_deposit_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_deposit_tanggal)), $this->config->item('key')),
					'trx_deposit_jumlah' => encrypt(number_format($row->trx_deposit_jumlah, 0, ',', '.'), $this->config->item('key')),
					'trx_deposit_admin' => encrypt(number_format($row->trx_deposit_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_deposit_total' => encrypt(number_format($row->trx_deposit_jumlah + $row->trx_deposit_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_deposit_channel' => encrypt($row->trx_deposit_channel, $this->config->item('key')),
					'trx_deposit_va' => encrypt($row->trx_deposit_va, $this->config->item('key')),
					'trx_deposit_link' => encrypt($row->trx_deposit_link, $this->config->item('key')),
					'trx_deposit_keterangan' => encrypt($row->trx_deposit_keterangan, $this->config->item('key')),
					'trx_deposit_notasi' => encrypt($row->trx_deposit_notasi, $this->config->item('key')),
					'trx_deposit_icon' => encrypt($row->trx_deposit_icon, $this->config->item('key')),
					'trx_deposit_rc' => encrypt($row->trx_deposit_rc, $this->config->item('key')),
					'trx_deposit_status' => encrypt($row->trx_deposit_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_deposit_kode()
	{
		$input = decrypt($this->input->post("trx_deposit_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
