<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Api_tripay_callback extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->helper([
            'jwt',
            'authorization',
            'callback_deposit'
        ]);
    }

    public function index()
    {
        $reqHeaders = $this->input->request_headers();
        $xIncomingCallbackTokenHeader = $reqHeaders['X-Callback-Signature'];
        $xTripayPrivateKey = $this->config->item('tripay_private_key');
        $rawRequestInput = file_get_contents('php://input');
        $xTripaysignature = hash_hmac('sha256', $rawRequestInput, $xTripayPrivateKey);

        if ($xIncomingCallbackTokenHeader == $xTripaysignature) {
            $rawRequestInput = file_get_contents('php://input');
            $response = json_decode($rawRequestInput, true);

            //TRIPAY
            $reference =  $response['reference'];
            $merchant_ref =  $response['merchant_ref'];
            $status =  $response['status'];
            $payment_method =  str_replace(' (Customizable)', '', $response['payment_method']);

            deposit($reference, $merchant_ref, $status,  $payment_method);
        } else {
            $sess["status"] = "400";
            $sess["pesan"] = $this->config->item('error_token');
            $keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
            $sess['data'] = array(
                'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
                'value' =>  encrypt(json_encode(array()), $keytoken)
            );
            echo json_encode($sess);
        }
    }
}
