<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_bukalapak_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$bukalapak = $this->db->query("SELECT * FROM tbl_mst_bukalapak  order by mst_bukalapak_urutan asc");

		if ($bukalapak->num_rows() > 0) {
			foreach ($bukalapak->result() as $row) {
				$data['bukalapak'][] = array(
					'mst_bukalapak_kode' => encrypt($row->mst_bukalapak_kode, $this->config->item('key')),
					'mst_bukalapak_nama' => encrypt($row->mst_bukalapak_nama, $this->config->item('key')),
					'mst_bukalapak_keterangan' => encrypt($row->mst_bukalapak_keterangan, $this->config->item('key')),
					'mst_bukalapak_notasi' => encrypt($row->mst_bukalapak_notasi, $this->config->item('key')),
					'mst_bukalapak_harga' => encrypt(number_format($row->mst_bukalapak_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_bukalapak_admin' => encrypt(number_format($row->mst_bukalapak_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_bukalapak_total' => encrypt(number_format($row->mst_bukalapak_harga + $row->mst_bukalapak_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_bukalapak_poin' => encrypt($row->mst_bukalapak_poin, $this->config->item('key')),
					'mst_bukalapak_urutan' => encrypt($row->mst_bukalapak_urutan, $this->config->item('key')),
					'mst_bukalapak_status' => encrypt($row->mst_bukalapak_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
